Rem
Rem $Header: rdbms/demo/aqmonitordemo1.sql /main/2 2010/08/13 10:44:26 xingjin Exp $
Rem
Rem aqmonitordemo1.sql
Rem
Rem Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      aqmonitordemo1.sql - demo the use of AQ monitor
Rem
Rem    DESCRIPTION
Rem      Demonstrate the use of dbms_aq_monitor package
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xingjin     07/30/10 - bug fix 9960101. 
Rem    xingjin     11/06/09 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100



------------------------------------------------------------------------
--         
--       1. Load Monitoring Package
--
------------------------------------------------------------------------

@ aqmonitor.sql


------------------------------------------------------------------------
--         
--       2. Start Monitoring Package
--
------------------------------------------------------------------------
CONNECT &aqmon_user/&aqmon_pass;

SET echo ON
SET serveroutput ON
SET pagesize 1000

-- specify queues which will be monitorted 
EXEC dbms_aq_monitor.add_queue_owner('McGrady');
EXEC dbms_aq_monitor.add_queue_owner('Duncan');

-- specify the frequency of capturing statistics
EXEC dbms_aq_monitor.set_monitoring_param('runtime_collect_freq', 30);
EXEC dbms_aq_monitor.set_monitoring_param('awr_dump_freq', 300);
EXEC dbms_aq_monitor.set_monitoring_param('accum_dump_freq', 300);

-- require the monitor to generate data files for the plotting script
EXEC dbms_aq_monitor.set_monitoring_param('file_plot', 1);

-- specify some paras in capturing statistics
EXEC dbms_aq_monitor.set_monitoring_param('shared_subsql_length', 200);
EXEC dbms_aq_monitor.set_monitoring_param('shared_memory_bound', 0.1);

-- specify more queue owners
EXEC dbms_aq_monitor.add_queue_owner('NIKEPLUS');
EXEC dbms_aq_monitor.add_queue_owner('AQUSER');
EXEC dbms_aq_monitor.add_queue_owner('AQUSER2');

-- show all the above and other default settings
EXEC dbms_aq_monitor.show_config;

-- start the monitor
EXEC dbms_aq_monitor.start_monitor;

-- Start your queue operations here ...


-- Now you can generate monitoring reports at any time (during or after your
-- queue operations):
-- EXEC dbms_aq_monitor.get_report;
-- EXEC dbms_aq_monitor.get_all_queues_reports;




